/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing;

import frc.emul.util.swing.AALabel;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.version.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public class UIAbout {
    public void open(Window window) {
        String string = Version.isBetaVersion() ? "Private Preview Build -- Please do not share!  :-)" : "About ParaJVE...";
        final JDialog jDialog = UIUtils.createDialog(window, string, true);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JButton jButton = new JButton(" O K ");
        jPanel.add((Component)jButton, "East");
        UIUtils.registerEscapeButton(jButton, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        container.add((Component)this.buildImageComp(), "West");
        container.add((Component)this.buildAboutPane(jPanel), "Center");
        UIUtils.setContainerBorder(container);
        jDialog.pack();
        UIUtils.center(jDialog, window, 0, 0);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    private JComponent buildImageComp() {
        int n = 1 + (new Random().nextInt() & Integer.MAX_VALUE) % 9;
        final Image image = UIUtils.loadImage("frc/emul/vectrex/images/about" + n + ".png");
        JComponent jComponent = new JComponent(){

            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                return new Dimension(image.getWidth(null) + insets.left + insets.right, image.getHeight(null) + insets.top + insets.bottom - 2);
            }

            public void paintComponent(Graphics graphics) {
                Insets insets = this.getInsets();
                graphics.drawImage(image, insets.left, insets.top, null);
            }
        };
        jComponent.setBorder(new CompoundBorder(Borders.BEVEL_LOW, new LineBorder(Color.BLACK, 5)));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jComponent, "North");
        return jPanel;
    }

    private JComponent buildAboutPane(JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2010, 11, 29);
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        String string = dateFormat.format(gregorianCalendar.getTime());
        StringBuffer stringBuffer = new StringBuffer(500);
        String string2 = Version.getContactEmail();
        String string3 = Version.getDevBlogURL();
        String string4 = Version.getDevBlogInternalURL();
        stringBuffer.append("<html><center><b><u>ParaJVE ").append(Version.sSHORT).append("</u></b><br>").append("<i>Build ").append(Version.sBUILD).append(" (").append(string).append(")</i><br>");
        if (Version.isBetaVersion()) {
            stringBuffer.append("<font color=008000>Registered to <b>").append(Version.getBetaOwner()).append("</b></font>");
        }
        stringBuffer.append("<br><hr><br>").append("Coded by Franck Chevassu (aka. Parabellum)</center><br><hr><br>").append("Comments are welcome at <a href=\"mail://").append(string2).append("\">").append(string2).append("</a><br>").append("<br>Feel free to visit ParaJVE development's blog at:<br>").append("<a href=\"").append(string4).append("\">").append(string3).append("</a>");
        jPanel.add(new AALabel(stringBuffer.toString()));
        jPanel.add((Component)jComponent, "South");
        return jPanel;
    }
}

